/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world;

import com.google.common.collect.Maps;
import io.github.fabricators_of_create.porting_lib.extensions.ITeleporter;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2265;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_5281;
import net.minecraft.class_5454;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.block.TFPortalBlock;
import twilightforest.util.WorldUtil;
import twilightforest.world.components.chunkgenerators.ChunkGeneratorTwilight;
import twilightforest.world.registration.TFGenerationSettings;

public class TFTeleporter
implements ITeleporter {
    private static final Map<class_2960, Map<class_2265, PortalPosition>> destinationCoordinateCache = new HashMap<class_2960, Map<class_2265, PortalPosition>>();
    private static final Object2LongMap<class_2265> columnMap = new Object2LongOpenHashMap();
    private static boolean locked;

    public TFTeleporter(boolean locked) {
        TFTeleporter.locked = locked;
    }

    @Nullable
    public class_5454 getPortalInfo(class_1297 entity, class_3218 dest, Function<class_3218, class_5454> defaultPortalInfo) {
        class_5454 pos = TFTeleporter.placeInExistingPortal(dest, entity, entity.method_24515(), entity instanceof class_1657);
        if (pos == null) {
            pos = TFTeleporter.moveToSafeCoords(dest, entity);
            this.makePortal(entity, dest, pos.field_25879);
            pos = TFTeleporter.placeInExistingPortal(dest, entity, new class_2338(pos.field_25879), entity instanceof class_1657);
        }
        return pos;
    }

    @Nullable
    private static class_5454 placeInExistingPortal(class_3218 world, class_1297 entity, class_2338 pos, boolean isPlayer) {
        PortalPosition portalPosition;
        int i = 200;
        boolean flag = true;
        class_2338 blockpos = class_2338.field_10980;
        class_2265 columnPos = new class_2265(pos);
        if (!isPlayer && columnMap.containsKey((Object)columnPos)) {
            return null;
        }
        PortalPosition portalPosition2 = portalPosition = destinationCoordinateCache.containsKey(world.method_27983().method_29177()) ? destinationCoordinateCache.get(world.method_27983().method_29177()).get(columnPos) : null;
        if (portalPosition != null) {
            blockpos = portalPosition.pos;
            portalPosition.lastUpdateTime = world.method_8510();
            flag = false;
        } else {
            double d0 = Double.MAX_VALUE;
            for (int i1 = -i; i1 <= i; ++i1) {
                for (int j1 = -i; j1 <= i; ++j1) {
                    class_1923 chunkPos;
                    if (!world.method_8621().method_11952(pos.method_10069(i1, 0, j1)) || !world.method_14178().field_17254.method_27055(chunkPos = new class_1923(pos.method_10069(i1, 0, j1)))) continue;
                    class_2818 chunk = world.method_8497(chunkPos.field_9181, chunkPos.field_9180);
                    class_2338 blockpos1 = pos.method_10069(i1, TFTeleporter.getScanHeight(world, pos) - pos.method_10264(), j1);
                    while (blockpos1.method_10264() >= 0) {
                        class_2338 blockpos2 = blockpos1.method_10074();
                        if (!(d0 >= 0.0 && blockpos1.method_10262((class_2382)pos) >= d0 || !TFTeleporter.isPortal(chunk.method_8320(blockpos1)))) {
                            blockpos2 = blockpos1.method_10074();
                            while (TFTeleporter.isPortal(chunk.method_8320(blockpos2))) {
                                blockpos1 = blockpos2;
                                blockpos2 = blockpos2.method_10074();
                            }
                            float d1 = (float)blockpos1.method_10262((class_2382)pos);
                            if (d0 < 0.0 || (double)d1 < d0) {
                                d0 = d1;
                                blockpos = blockpos1;
                                i = class_3532.method_15386((float)class_3532.method_15355((float)d1));
                            }
                        }
                        blockpos1 = blockpos2;
                    }
                }
            }
        }
        if (blockpos.equals((Object)class_2338.field_10980)) {
            long factor = world.method_8510() + 300L;
            columnMap.put((Object)columnPos, factor);
            return null;
        }
        if (flag) {
            destinationCoordinateCache.putIfAbsent(world.method_27983().method_29177(), Maps.newHashMapWithExpectedSize((int)4096));
            destinationCoordinateCache.get(world.method_27983().method_29177()).put(columnPos, new PortalPosition(blockpos, world.method_8510()));
            world.method_14178().method_17297(class_3230.field_19280, new class_1923(blockpos), 3, (Object)new class_2338(columnPos.field_10708, blockpos.method_10264(), columnPos.field_10707));
        }
        class_2338[] portalBorder = TFTeleporter.getBoundaryPositions(world, blockpos).toArray(new class_2338[0]);
        class_2338 borderPos = portalBorder[0];
        double portalX = (double)borderPos.method_10263() + 0.5;
        double portalY = (double)borderPos.method_10264() + 1.0;
        double portalZ = (double)borderPos.method_10260() + 0.5;
        return TFTeleporter.makePortalInfo(entity, portalX, portalY, portalZ);
    }

    private static int getScanHeight(class_3218 world, class_2338 pos) {
        return TFTeleporter.getScanHeight(world, pos.method_10263(), pos.method_10260());
    }

    private static int getScanHeight(class_3218 world, int x, int z) {
        int worldHeight = world.method_31600() - 1;
        int chunkHeight = world.method_8497(x >> 4, z >> 4).method_12031() + 15;
        return Math.min(worldHeight, chunkHeight);
    }

    private static boolean isPortal(class_2680 state) {
        return state.method_26204() == TFBlocks.TWILIGHT_PORTAL.get();
    }

    private static Set<class_2338> getBoundaryPositions(class_3218 world, class_2338 start) {
        HashSet<class_2338> result = new HashSet<class_2338>();
        HashSet<class_2338> checked = new HashSet<class_2338>();
        checked.add(start);
        TFTeleporter.checkAdjacent(world, start, checked, result);
        return result;
    }

    private static void checkAdjacent(class_3218 world, class_2338 pos, Set<class_2338> checked, Set<class_2338> result) {
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            class_2338 offset = pos.method_10093(facing);
            if (!checked.add(offset)) continue;
            if (TFTeleporter.isPortalAt(world, offset)) {
                TFTeleporter.checkAdjacent(world, offset, checked, result);
                continue;
            }
            result.add(offset);
        }
    }

    private static boolean isPortalAt(class_3218 world, class_2338 pos) {
        return TFTeleporter.isPortal(world.method_8320(pos));
    }

    private static class_5454 moveToSafeCoords(class_3218 world, class_1297 entity) {
        boolean checkProgression = TFGenerationSettings.isProgressionEnforced((class_1937)world);
        class_2338 pos = entity.method_24515();
        if (TFTeleporter.isSafeAround((class_1937)world, pos, entity, checkProgression)) {
            TwilightForestMod.LOGGER.debug("Portal destination looks safe!");
            return TFTeleporter.makePortalInfo(entity, entity.method_19538());
        }
        TwilightForestMod.LOGGER.debug("Portal destination looks unsafe, rerouting!");
        class_2338 safeCoords = TFTeleporter.findSafeCoords(world, 200, pos, entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.debug("Safely rerouted!");
            return TFTeleporter.makePortalInfo(entity, safeCoords.method_10263(), entity.method_23318(), safeCoords.method_10260());
        }
        TwilightForestMod.LOGGER.info("Did not find a safe portal spot at first try, trying again with longer range.");
        safeCoords = TFTeleporter.findSafeCoords(world, 400, pos, entity, checkProgression);
        if (safeCoords != null) {
            TwilightForestMod.LOGGER.info("Safely rerouted to long range portal.  Return trip not guaranteed.");
            return TFTeleporter.makePortalInfo(entity, safeCoords.method_10263(), entity.method_23318(), safeCoords.method_10260());
        }
        TwilightForestMod.LOGGER.warn("Still did not find a safe portal spot.");
        return TFTeleporter.makePortalInfo(entity, entity.method_19538());
    }

    public static boolean isSafeAround(class_1937 world, class_2338 pos, class_1297 entity, boolean checkProgression) {
        if (!TFTeleporter.isSafe(world, pos, entity, checkProgression)) {
            return false;
        }
        for (class_2350 facing : class_2350.class_2353.field_11062) {
            if (TFTeleporter.isSafe(world, pos.method_10079(facing, 16), entity, checkProgression)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSafe(class_1937 world, class_2338 pos, class_1297 entity, boolean checkProgression) {
        return TFTeleporter.checkPos(world, pos) && (!checkProgression || TFTeleporter.checkBiome(world, pos, entity)) && TFTeleporter.checkStructure(world, pos);
    }

    private static boolean checkPos(class_1937 world, class_2338 pos) {
        return world.method_8621().method_11952(pos);
    }

    private static boolean checkStructure(class_1937 world, class_2338 pos) {
        ChunkGeneratorTwilight generator = WorldUtil.getChunkGenerator((class_1936)world);
        if (generator != null) {
            return !TFGenerationSettings.locateTFStructureInRange((class_5281)((class_3218)world), pos, 0).isPresent();
        }
        return true;
    }

    private static boolean checkBiome(class_1937 world, class_2338 pos, class_1297 entity) {
        return TFGenerationSettings.isBiomeSafeFor((class_1959)world.method_23753(pos).comp_349(), entity);
    }

    @Nullable
    private static class_2338 findSafeCoords(class_3218 world, int range, class_2338 pos, class_1297 entity, boolean checkProgression) {
        int attempts = range / 8;
        for (int x = 0; x < attempts; ++x) {
            for (int z = 0; z < attempts; ++z) {
                class_2338 dPos = new class_2338(pos.method_10263() + x * attempts - range / 2, 100, pos.method_10260() + z * attempts - range / 2);
                if (!TFTeleporter.isSafeAround((class_1937)world, dPos, entity, checkProgression)) continue;
                return dPos;
            }
        }
        return null;
    }

    private void makePortal(class_1297 entity, class_3218 world, class_243 pos) {
        TFTeleporter.loadSurroundingArea(world, pos);
        class_2338 spot = TFTeleporter.findPortalCoords(world, pos, blockPos -> TFTeleporter.isPortalAt(world, blockPos));
        String name = entity.method_5477().getString();
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found existing portal for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cachePortalCoords(world, pos, spot);
            return;
        }
        spot = TFTeleporter.findPortalCoords(world, pos, blockpos -> TFTeleporter.isIdealForPortal(world, blockpos));
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found ideal portal spot for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cachePortalCoords(world, pos, this.makePortalAt((class_1937)world, spot));
            return;
        }
        TwilightForestMod.LOGGER.debug("Did not find ideal portal spot, shooting for okay one for {}", (Object)name);
        spot = TFTeleporter.findPortalCoords(world, pos, blockPos -> TFTeleporter.isOkayForPortal(world, blockPos));
        if (spot != null) {
            TwilightForestMod.LOGGER.debug("Found okay portal spot for {} at {}", (Object)name, (Object)spot);
            TFTeleporter.cachePortalCoords(world, pos, this.makePortalAt((class_1937)world, spot));
            return;
        }
        TwilightForestMod.LOGGER.debug("Did not even find an okay portal spot, just making a random one for {}", (Object)name);
        double yFactor = TFTeleporter.getYFactor(world);
        TFTeleporter.cachePortalCoords(world, pos, this.makePortalAt((class_1937)world, new class_2338(entity.method_23317(), entity.method_23318() * yFactor - 1.0, entity.method_23321())));
    }

    private static void loadSurroundingArea(class_3218 world, class_243 pos) {
        int x = class_3532.method_15357((double)pos.field_1352) >> 4;
        int z = class_3532.method_15357((double)pos.field_1351) >> 4;
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                world.method_8497(x + dx, z + dz);
            }
        }
    }

    @Nullable
    private static class_2338 findPortalCoords(class_3218 world, class_243 loc, Predicate<class_2338> predicate) {
        double yFactor = TFTeleporter.getYFactor(world);
        int entityX = class_3532.method_15357((double)loc.field_1352);
        int entityZ = class_3532.method_15357((double)loc.field_1350);
        class_2338.class_2339 pos = new class_2338.class_2339();
        double spotWeight = -1.0;
        class_2338 spot = null;
        int range = 16;
        for (int rx = entityX - range; rx <= entityX + range; ++rx) {
            double xWeight = (double)rx + 0.5 - loc.field_1352;
            for (int rz = entityZ - range; rz <= entityZ + range; ++rz) {
                double zWeight = (double)rz + 0.5 - loc.field_1350;
                for (int ry = TFTeleporter.getScanHeight(world, rx, rz); ry >= world.method_31607(); --ry) {
                    if (!world.method_22347((class_2338)pos.method_10103(rx, ry, rz))) continue;
                    while (ry > world.method_31607() && world.method_22347((class_2338)pos.method_10103(rx, ry - 1, rz))) {
                        --ry;
                    }
                    double yWeight = (double)ry + 0.5 - loc.field_1351 * yFactor;
                    double rPosWeight = xWeight * xWeight + yWeight * yWeight + zWeight * zWeight;
                    if (!(spotWeight < 0.0) && !(rPosWeight < spotWeight) || !predicate.test((class_2338)pos)) continue;
                    spotWeight = rPosWeight;
                    spot = pos.method_10062();
                }
            }
        }
        return spot;
    }

    private static double getYFactor(class_3218 world) {
        return world.method_27983().method_29177().equals((Object)class_1937.field_25179.method_29177()) ? 2.0 : 0.5;
    }

    private static void cachePortalCoords(class_3218 world, class_243 loc, class_2338 pos) {
        int x = class_3532.method_15357((double)loc.field_1352);
        int z = class_3532.method_15357((double)loc.field_1350);
        destinationCoordinateCache.putIfAbsent(world.method_27983().method_29177(), Maps.newHashMapWithExpectedSize((int)4096));
        destinationCoordinateCache.get(world.method_27983().method_29177()).put(new class_2265(x, z), new PortalPosition(pos, world.method_8510()));
    }

    private static boolean isIdealForPortal(class_3218 world, class_2338 pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = 0; potentialY < 4; ++potentialY) {
                    class_2338 tPos = pos.method_10069(potentialX - 1, potentialY, potentialZ - 1);
                    class_3614 material = world.method_8320(tPos).method_26207();
                    if ((potentialY != 0 || material == class_3614.field_15945) && (potentialY < 1 || material.method_15800())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected class_2338 makePortalAt(class_1937 world, class_2338 pos) {
        class_2680 grass = class_2246.field_10219.method_9564();
        world.method_8501(pos.method_10067().method_10095(), grass);
        world.method_8501(pos.method_10095(), grass);
        world.method_8501(pos.method_10078().method_10095(), grass);
        world.method_8501(pos.method_10089(2).method_10095(), grass);
        world.method_8501(pos.method_10067(), grass);
        world.method_8501(pos.method_10089(2), grass);
        world.method_8501(pos.method_10067().method_10072(), grass);
        world.method_8501(pos.method_10089(2).method_10072(), grass);
        world.method_8501(pos.method_10067().method_10077(2), grass);
        world.method_8501(pos.method_10077(2), grass);
        world.method_8501(pos.method_10078().method_10077(2), grass);
        world.method_8501(pos.method_10089(2).method_10077(2), grass);
        class_2680 dirt = class_2246.field_10566.method_9564();
        world.method_8501(pos.method_10074(), dirt);
        world.method_8501(pos.method_10078().method_10074(), dirt);
        world.method_8501(pos.method_10072().method_10074(), dirt);
        world.method_8501(pos.method_10078().method_10072().method_10074(), dirt);
        class_2680 portal = (class_2680)((TFPortalBlock)((Object)TFBlocks.TWILIGHT_PORTAL.get())).method_9564().method_11657((class_2769)TFPortalBlock.DISALLOW_RETURN, (Comparable)Boolean.valueOf(locked || (Boolean)TFConfig.COMMON_CONFIG.shouldReturnPortalBeUsable.get() == false));
        world.method_8652(pos, portal, 2);
        world.method_8652(pos.method_10078(), portal, 2);
        world.method_8652(pos.method_10072(), portal, 2);
        world.method_8652(pos.method_10078().method_10072(), portal, 2);
        for (int dx = -1; dx <= 2; ++dx) {
            for (int dz = -1; dz <= 2; ++dz) {
                for (int dy = 1; dy <= 5; ++dy) {
                    world.method_8650(pos.method_10069(dx, dy, dz), false);
                }
            }
        }
        world.method_8652(pos.method_10067().method_10095().method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10095().method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10078().method_10095().method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10089(2).method_10095().method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10067().method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10089(2).method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10067().method_10072().method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10089(2).method_10072().method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10067().method_10077(2).method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10077(2).method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10078().method_10077(2).method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        world.method_8652(pos.method_10089(2).method_10077(2).method_10084(), TFTeleporter.randNatureBlock(world.field_9229), 2);
        return pos;
    }

    private static class_2680 randNatureBlock(Random random) {
        class_2248[] blocks = new class_2248[]{class_2246.field_10251, class_2246.field_10559, class_2246.field_10479, class_2246.field_10449, class_2246.field_10182};
        return blocks[random.nextInt(blocks.length)].method_9564();
    }

    private static boolean isOkayForPortal(class_3218 world, class_2338 pos) {
        for (int potentialZ = 0; potentialZ < 4; ++potentialZ) {
            for (int potentialX = 0; potentialX < 4; ++potentialX) {
                for (int potentialY = 0; potentialY < 4; ++potentialY) {
                    class_2338 tPos = pos.method_10069(potentialX - 1, potentialY, potentialZ - 1);
                    class_3614 material = world.method_8320(tPos).method_26207();
                    if ((potentialY != 0 || material.method_15799() || material.method_15797()) && (potentialY < 1 || material.method_15800())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static class_5454 makePortalInfo(class_1297 entity, double x, double y, double z) {
        return TFTeleporter.makePortalInfo(entity, new class_243(x, y, z));
    }

    private static class_5454 makePortalInfo(class_1297 entity, class_243 pos) {
        return new class_5454(pos, class_243.field_1353, entity.method_36454(), entity.method_36455());
    }

    public class_1297 placeEntity(class_1297 entity, class_3218 currentWorld, class_3218 destWorld, float yaw, Function<Boolean, class_1297> repositionEntity) {
        entity.field_6017 = 0.0f;
        return repositionEntity.apply(false);
    }

    static class PortalPosition {
        public final class_2338 pos;
        long lastUpdateTime;

        PortalPosition(class_2338 pos, long time) {
            this.pos = pos;
            this.lastUpdateTime = time;
        }
    }
}

